/****************************************************************************/
/* FILE NAME: main.c                       COPYRIGHT (c) Freescale 2006   	*/
/*                                                All Rights Reserved     	*/
/* DESCRIPTION:                                                           	*/
/* This is the main file for the MPC5561 Multi-Module Test Phase 2 (MMTP2).	*/
/* This is an extension to MMTP1 application. The main file 			  	*/
/* configures the modules used and then starts the test. The interrupt	  	*/
/* handler then calls the necessary functions used.						  	*/
/*========================================================================	*/
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               	*/
/* ---   -----------    ----------    ---------------------               	*/
/* 0.1	  D.Paterson	01/Feb/07    Initial Version					  	*/
/****************************************************************************/
#include "mpc5500_usrccdcfg.h"
#include "mpc5500_xcptn.h" 
#include "mpc5561.h"
#include "ESCI_Esys.h"

extern int can_complete;
  
void setup_functions(void);
void setup_FMPLL(void);
void clear_TCD(void);
int loop_cnt;

/**************************************************************************/
/* FUNCTION     : main		  											  */
/* PURPOSE      : Calls the setup functions and initializes the		 	  */
/*				  interrupts and eMIOS to trigger the test				  */
/**************************************************************************/
void main (void) { 

	// Setup all modules used in the test
	setup_functions();
	
}

/**************************************************************************/
/* FUNCTION     : setup_functions										  */
/* PURPOSE      : Configures the settings for all modules used in the     */
/* 				  the multi-module test									  */
/**************************************************************************/
void setup_functions(void) {

	int i=0;
	int loop_cnt = 0;
	
	// Enable SPE
	asm("mfmsr r3");
	asm("lis r4, 0x0200");
	asm("or r3,r4,r3");
	asm("mtmsr r3");
	
	/* OBE=ON, IBE=OFF, Primary mode */
	SIU.PCR[203].R = 0x0200;				//Used for measuing loop time
	
	
	// Setup modules
	setup_FMPLL();							// Setup the PLL
	clear_TCD();							// Clear SRAM located eDMA TCD memory 
    setup_DSPI();							// Setup DSPI B & C and eDMA modules
    setup_FlexCAN();						// Setup FlexCAN A & C modules
  	Setup_eQADC(); 							// Setup the eQADC & eDMA modules
    setup_eSCI();  							// Setup the eSCI 
    xcptn_xmpl();							// Setup the interrupt handler
    setup_eMIOS();  						// Setup the eSCI module

    while(1)
    {							       
	 
	    // Wait for CAN to have received results
    	while(!can_complete){}
	    
    	// Clear flag	    
    	can_complete = 0;
    	
    	// Increment loop counter
    	loop_cnt++;
    	
	}
}

/**************************************************************************/
/* FUNCTION     : setup_FMPLL											  */
/* PURPOSE      : Configures FMPLL to 128 MHz                             */
/**************************************************************************/
void setup_FMPLL(void) {
	
	FMPLL.SYNCR.R = 0x46000000;		// 128MHz for Lance / Tiger
	
	// Wait for FMPLL to lock
	while(FMPLL.SYNSR.B.LOCK != 1);
	
	//Setup ENGCLK (Source = 40MHz crystal)
	SIU.PCR[214].B.OBE = 0x1;
	SIU.ECCR.R = 0x0000FA81;
}

/**************************************************************************/
/* FUNCTION     : clear_TCD											      */
/* PURPOSE      : Clear RAM located eDMA TCD memory                       */
/**************************************************************************/
void clear_TCD(void) {
	
	 int i=0;
	
	 // Clear TCD RAM
	 // - Ensures correct operation of the eDMA module
	 for(i=0;i<1024;i=i+4)
	 {
	 	*(unsigned int*)(0xFFF45000+i) = 0x00000000; 
	 }
	 
 }